USE [master];

SET NOCOUNT ON;

BEGIN TRY

	IF SUSER_ID('$(I360LoginDomain)\$(I360LoginName)') IS NULL
	BEGIN
		RAISERROR('''$(I360LoginDomain)\$(I360LoginName)'' is not a valid login.', 15, 1);
	END

	EXECUTE AS LOGIN = 'sa';
		
	PRINT 'Grant VIEW SERVER STATE permission to ''$(I360LoginDomain)\$(I360LoginName)'' SQL login';
	GRANT VIEW SERVER STATE TO [$(I360LoginDomain)\$(I360LoginName)];
	
	REVERT;

	PRINT 'Add ''$(I360LoginDomain)\$(I360LoginName)'' SQL login to ''bulkadmin'' fixed server role'
	EXEC sp_addsrvrolemember @loginame = N'$(I360LoginDomain)\$(I360LoginName)', @rolename = N'bulkadmin'
	
END TRY
BEGIN CATCH

	DECLARE @msg NVARCHAR(4000),
			@new_line	CHAR(2)
	
	SET @new_line = CHAR(13) + CHAR(10);

	--Report for error  (error retrieval routine)
	SET @msg =  'An exception has occurred!' + @new_line +
				' - Error Number: '    + CAST(ERROR_NUMBER() AS VARCHAR(11))	+ @new_line +
				' - Error Severity: '  + CAST(ERROR_SEVERITY() AS VARCHAR(11))	+ @new_line +
				' - Error State: '     + CAST(ERROR_STATE() AS VARCHAR(11))		+ @new_line +
				' - Error Procedure: ' + ISNULL(ERROR_PROCEDURE(), 'N/A')		+ @new_line +
				' - Error Line: '      + CAST(ERROR_LINE() AS VARCHAR(11))		+ @new_line +
				' - Error Message: '   + ISNULL(ERROR_MESSAGE(), 'N/A')			+ @new_line +
				'Rolling back any changes...';

	RAISERROR(@msg, 16, 1);
		
END CATCH

SET NOCOUNT OFF;